<?php
include 'indexapoteker.php';
?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-0">Stok Gudang</h2>
                    <small class="text-muted">Lihat informasi stok obat di setiap gudang</small>
                </div>
                <?php if ($_SESSION['role'] === 'petugas'): ?>
                    <button class="btn btn-success rounded" data-bs-toggle="modal" data-bs-target="#addStokModal">
                        <i class="ti ti-plus"></i> Tambah Stok
                    </button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Filter Gudang -->
        <div class="row mb-3">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET" action="">
                            <div class="row align-items-end">
                                <div class="col-md-4">
                                    <label class="form-label"><i class="ti ti-building-warehouse"></i> Filter Gudang</label>
                                    <select class="form-select" name="filter_gudang" onchange="this.form.submit()">
                                        <option value="">Semua Gudang</option>
                                        <?php
                                        $query_gudang = "SELECT * FROM gudang ORDER BY nama_gudang ASC";
                                        $result_gudang = mysqli_query($conn, $query_gudang);
                                        $selected_gudang = isset($_GET['filter_gudang']) ? $_GET['filter_gudang'] : '';
                                        while ($gudang = mysqli_fetch_assoc($result_gudang)) {
                                            $selected = ($selected_gudang == $gudang['id_gudang']) ? 'selected' : '';
                                            echo '<option value="'.$gudang['id_gudang'].'" '.$selected.'>'.$gudang['nama_gudang'].' - '.$gudang['lokasi'].'</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label"><i class="ti ti-search"></i> Cari Obat</label>
                                    <input type="text" class="form-control" name="search" placeholder="Nama atau kode obat..." value="<?php echo isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                                </div>
                                <div class="col-md-4">
                                    <button type="submit" class="btn btn-primary"><i class="ti ti-search"></i> Filter</button>
                                    <a href="stokapoteker.php" class="btn btn-outline-secondary"><i class="ti ti-refresh"></i> Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Stok (untuk semua role) -->
        <div class="row mb-3">
            <?php
            $query_stats = "SELECT 
                            COUNT(DISTINCT s.id_obat) as total_jenis_obat,
                            COUNT(DISTINCT s.id_gudang) as total_gudang,
                            SUM(s.jumlah) as total_unit
                          FROM stok s";
            $result_stats = mysqli_query($conn, $query_stats);
            $stats = mysqli_fetch_assoc($result_stats);
            
            $query_kurang = "SELECT COUNT(DISTINCT o.id_obat) as total_kurang
                            FROM obat o
                            LEFT JOIN (SELECT id_obat, SUM(jumlah) as total FROM stok GROUP BY id_obat) s 
                            ON o.id_obat = s.id_obat
                            WHERE COALESCE(s.total, 0) < o.stok_minimum";
            $result_kurang = mysqli_query($conn, $query_kurang);
            $kurang = mysqli_fetch_assoc($result_kurang);
            ?>
            <div class="col-md-3 col-sm-6">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <i class="ti ti-pill" style="font-size: 2.5rem;"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h3 class="text-white mb-1"><?php echo $stats['total_jenis_obat']; ?></h3>
                                <p class="mb-0">Jenis Obat</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <i class="ti ti-building-warehouse" style="font-size: 2.5rem;"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h3 class="text-white mb-1"><?php echo $stats['total_gudang']; ?></h3>
                                <p class="mb-0">Total Gudang</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <i class="ti ti-package" style="font-size: 2.5rem;"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h3 class="text-white mb-1"><?php echo number_format($stats['total_unit'], 0, ',', '.'); ?></h3>
                                <p class="mb-0">Total Unit</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6">
                <div class="card bg-danger text-white">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <i class="ti ti-alert-triangle" style="font-size: 2.5rem;"></i>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h3 class="text-white mb-1"><?php echo $kurang['total_kurang']; ?></h3>
                                <p class="mb-0">Stok Kurang</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabel Stok -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Stok per Gudang</h5>
                        <small><?php echo ($_SESSION['role'] === 'petugas') ? 'Kelola stok obat di setiap gudang' : 'Lihat informasi stok obat'; ?></small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode Obat</th>
                                        <th>Nama Obat</th>
                                        <th>Gudang</th>
                                        <th>Lokasi</th>
                                        <th>Jumlah Stok</th>
                                        <th>Satuan</th>
                                        <th>Status</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $where = array();
                                    if (isset($_GET['filter_gudang']) && !empty($_GET['filter_gudang'])) {
                                        $filter_gudang = mysqli_real_escape_string($conn, $_GET['filter_gudang']);
                                        $where[] = "s.id_gudang = '$filter_gudang'";
                                    }
                                    if (isset($_GET['search']) && !empty($_GET['search'])) {
                                        $search = mysqli_real_escape_string($conn, $_GET['search']);
                                        $where[] = "(o.nama_obat LIKE '%$search%' OR o.kode_obat LIKE '%$search%')";
                                    }
                                    
                                    $where_clause = count($where) > 0 ? "WHERE " . implode(" AND ", $where) : "";
                                    
                                    $query = "SELECT s.*, o.kode_obat, o.nama_obat, o.satuan, o.stok_minimum, o.stok_maksimum,
                                              g.nama_gudang, g.lokasi,
                                              (SELECT COALESCE(SUM(jumlah), 0) FROM stok WHERE id_obat = o.id_obat) as total_stok_semua_gudang
                                              FROM stok s
                                              JOIN obat o ON s.id_obat = o.id_obat
                                              JOIN gudang g ON s.id_gudang = g.id_gudang
                                              $where_clause
                                              ORDER BY g.nama_gudang ASC, o.nama_obat ASC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    
                                    if (mysqli_num_rows($result) > 0) {
                                        while ($row = mysqli_fetch_assoc($result)) {
                                            $status_badge = '';
                                            if ($row['total_stok_semua_gudang'] < $row['stok_minimum']) {
                                                $status_badge = '<span class="badge bg-danger">Stok Kurang</span>';
                                            } elseif ($row['total_stok_semua_gudang'] > $row['stok_maksimum']) {
                                                $status_badge = '<span class="badge bg-info">Stok Berlebih</span>';
                                            } else {
                                                $status_badge = '<span class="badge bg-success">Stok Normal</span>';
                                            }
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><strong><?= $row['kode_obat'] ?></strong></td>
                                        <td><?= $row['nama_obat'] ?></td>
                                        <td><span class="badge bg-primary"><?= $row['nama_gudang'] ?></span></td>
                                        <td><i class="ti ti-map-pin"></i> <?= $row['lokasi'] ?></td>
                                        <td class="text-end">
                                            <strong class="text-primary fs-6"><?= $row['jumlah'] ?></strong>
                                            <br><small class="text-muted">Total: <?= $row['total_stok_semua_gudang'] ?></small>
                                        </td>
                                        <td><?= $row['satuan'] ?></td>
                                        <td><?= $status_badge ?></td>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#detailStokModal<?php echo $row['id_stok']; ?>" title="Detail">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <?php if ($_SESSION['role'] === 'petugas'): ?>
                                                <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editStokModal<?php echo $row['id_stok']; ?>" title="Edit">
                                                    <i class="ti ti-edit"></i>
                                                </button>
                                                <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteStokModal<?php echo $row['id_stok']; ?>" title="Hapus">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php 
                                        } 
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Tambah Stok (hanya untuk petugas) -->
<?php if ($_SESSION['role'] === 'petugas'): ?>
<div class="modal fade" id="addStokModal" tabindex="-1" aria-labelledby="addStokModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addStokModalLabel"><i class="ti ti-plus"></i> Tambah Stok</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="tambahstokapoteker.php" method="POST">
                <div class="modal-body">
                    <input type="hidden" name="redirect_to" value="stokapoteker.php">
                    <div class="mb-3">
                        <label for="id_obat" class="form-label">Pilih Obat <span class="text-danger">*</span></label>
                        <select class="form-select" id="id_obat" name="id_obat" required onchange="loadObatInfo(this.value)">
                            <option value="">-- Pilih Obat --</option>
                            <?php
                            $query_obat = "SELECT o.*, COALESCE(SUM(s.jumlah), 0) as total_stok 
                                          FROM obat o 
                                          LEFT JOIN stok s ON o.id_obat = s.id_obat 
                                          GROUP BY o.id_obat 
                                          ORDER BY o.nama_obat ASC";
                            $result_obat = mysqli_query($conn, $query_obat);
                            while ($obat = mysqli_fetch_assoc($result_obat)) {
                                echo '<option value="'.$obat['id_obat'].'" 
                                      data-kode="'.$obat['kode_obat'].'" 
                                      data-satuan="'.$obat['satuan'].'" 
                                      data-stok="'.$obat['total_stok'].'"
                                      data-min="'.$obat['stok_minimum'].'"
                                      data-max="'.$obat['stok_maksimum'].'">
                                      '.$obat['kode_obat'].' - '.$obat['nama_obat'].' (Stok: '.$obat['total_stok'].')
                                      </option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div id="obat-info" class="alert alert-info d-none mb-3">
                        <strong>Info Obat:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Kode: <span id="info-kode">-</span></li>
                            <li>Satuan: <span id="info-satuan">-</span></li>
                            <li>Total Stok: <span id="info-stok">-</span></li>
                            <li>Stok Min/Max: <span id="info-min">-</span> / <span id="info-max">-</span></li>
                        </ul>
                    </div>
                    
                    <div class="mb-3">
                        <label for="id_gudang" class="form-label">Pilih Gudang <span class="text-danger">*</span></label>
                        <select class="form-select" id="id_gudang" name="id_gudang" required>
                            <option value="">-- Pilih Gudang --</option>
                            <?php
                            $query_gudang = "SELECT * FROM gudang ORDER BY nama_gudang ASC";
                            $result_gudang = mysqli_query($conn, $query_gudang);
                            while ($gudang = mysqli_fetch_assoc($result_gudang)) {
                                echo '<option value="'.$gudang['id_gudang'].'">'.$gudang['nama_gudang'].' - '.$gudang['lokasi'].'</option>';
                            }
                            ?>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="jumlah" class="form-label">Jumlah Stok <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="jumlah" name="jumlah" min="1" required>
                        <small class="text-muted">Masukkan jumlah stok yang akan ditambahkan</small>
                    </div>
                    
                    <div class="alert alert-warning mb-0">
                        <i class="ti ti-info-circle"></i> <strong>Catatan:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Jika obat sudah ada di gudang, stok akan ditambahkan</li>
                            <li>Jika belum ada, akan membuat entry stok baru</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-success" name="tambah"><i class="ti ti-device-floppy"></i> Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<?php
$query = "SELECT s.*, o.kode_obat, o.nama_obat, o.bentuk, o.satuan, o.harga_beli, o.harga_jual, o.stok_minimum, o.stok_maksimum,
          g.nama_gudang, g.lokasi, g.keterangan,
          (SELECT COALESCE(SUM(jumlah), 0) FROM stok WHERE id_obat = o.id_obat) as total_stok_semua_gudang
          FROM stok s
          JOIN obat o ON s.id_obat = o.id_obat
          JOIN gudang g ON s.id_gudang = g.id_gudang
          ORDER BY s.id_stok DESC";
$result = mysqli_query($conn, $query);
while ($row = mysqli_fetch_assoc($result)) {
?>

<!-- Modal Detail Stok (untuk semua role) -->
<div class="modal fade" id="detailStokModal<?php echo $row['id_stok']; ?>" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="ti ti-info-circle"></i> Detail Stok Gudang</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="card border-primary mb-3">
                    <div class="card-header bg-primary">
                        <h6 class="mb-0 text-white"><i class="ti ti-pill"></i> Informasi Obat</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-sm table-borderless mb-0">
                                    <tr>
                                        <th width="45%">Kode Obat</th>
                                        <td>: <strong><?php echo $row['kode_obat']; ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Nama Obat</th>
                                        <td>: <strong class="text-primary"><?php echo $row['nama_obat']; ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Bentuk</th>
                                        <td>: <?php echo $row['bentuk']; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Satuan</th>
                                        <td>: <?php echo $row['satuan']; ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-sm table-borderless mb-0">
                                    <tr>
                                        <th width="45%">Harga Beli</th>
                                        <td>: Rp <?php echo number_format($row['harga_beli'], 0, ',', '.'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Harga Jual</th>
                                        <td>: <span class="text-success fw-bold">Rp <?php echo number_format($row['harga_jual'], 0, ',', '.'); ?></span></td>
                                    </tr>
                                    <tr>
                                        <th>Stok Minimum</th>
                                        <td>: <?php echo $row['stok_minimum']; ?> <?php echo $row['satuan']; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Stok Maksimum</th>
                                        <td>: <?php echo $row['stok_maksimum']; ?> <?php echo $row['satuan']; ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-success mb-3">
                    <div class="card-header bg-success">
                        <h6 class="mb-0 text-white"><i class="ti ti-building-warehouse"></i> Informasi Gudang</h6>
                    </div>
                    <div class="card-body">
                        <table class="table table-sm table-borderless mb-0">
                            <tr>
                                <th width="22%">Nama Gudang</th>
                                <td>: <span class="badge bg-primary fs-6"><?php echo $row['nama_gudang']; ?></span></td>
                            </tr>
                            <tr>
                                <th>Lokasi</th>
                                <td>: <i class="ti ti-map-pin"></i> <?php echo $row['lokasi']; ?></td>
                            </tr>
                            <tr>
                                <th>Keterangan</th>
                                <td>: <?php echo !empty($row['keterangan']) ? $row['keterangan'] : '<span class="text-muted">-</span>'; ?></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="card border-info mb-0">
                    <div class="card-header bg-info">
                        <h6 class="mb-0 text-white"><i class="ti ti-package"></i> Informasi Stok</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <h6 class="mb-2">Stok di Gudang Ini</h6>
                                    <h2 class="text-success mb-0"><strong><?php echo $row['jumlah']; ?></strong></h2>
                                    <small class="text-muted"><?php echo $row['satuan']; ?></small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="p-3 bg-light rounded">
                                    <h6 class="mb-2">Total Semua Gudang</h6>
                                    <h2 class="text-primary mb-0"><strong><?php echo $row['total_stok_semua_gudang']; ?></strong></h2>
                                    <small class="text-muted"><?php echo $row['satuan']; ?></small>
                                </div>
                            </div>
                        </div>
                        
                        <?php
                        $total = $row['total_stok_semua_gudang'];
                        $min = $row['stok_minimum'];
                        $max = $row['stok_maksimum'];
                        
                        if ($total < $min) {
                            echo '<div class="alert alert-danger mt-3 mb-0">';
                            echo '<i class="ti ti-alert-triangle"></i> <strong>Peringatan!</strong> Total stok di bawah minimum. Segera lakukan pemesanan ulang!';
                            echo '<br><small>Kekurangan: ' . ($min - $total) . ' ' . $row['satuan'] . '</small>';
                            echo '</div>';
                        } elseif ($total > $max) {
                            echo '<div class="alert alert-info mt-3 mb-0">';
                            echo '<i class="ti ti-info-circle"></i> <strong>Informasi:</strong> Total stok melebihi maksimum. Pertimbangkan untuk mengurangi pemesanan.';
                            echo '<br><small>Kelebihan: ' . ($total - $max) . ' ' . $row['satuan'] . '</small>';
                            echo '</div>';
                        } else {
                            echo '<div class="alert alert-success mt-3 mb-0">';
                            echo '<i class="ti ti-check"></i> <strong>Status Stok: Normal</strong>';
                            echo '<br><small>Stok dalam rentang minimum (' . $min . ') - maksimum (' . $max . ')</small>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Stok (hanya untuk petugas) -->
<?php if ($_SESSION['role'] === 'petugas'): ?>
<div class="modal fade" id="editStokModal<?php echo $row['id_stok']; ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="ti ti-edit"></i> Edit Stok</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="editstokapoteker.php" method="POST">
                <input type="hidden" name="id_stok" value="<?php echo $row['id_stok']; ?>">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <strong>Obat:</strong> <?php echo $row['nama_obat']; ?><br>
                        <strong>Gudang:</strong> <?php echo $row['nama_gudang']; ?>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Stok Saat Ini</label>
                        <input type="text" class="form-control" value="<?php echo $row['jumlah']; ?> <?php echo $row['satuan']; ?>" readonly>
                    </div>
                    
                    <div class="mb-3">
                        <label for="jumlah_baru" class="form-label">Jumlah Stok Baru <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="jumlah_baru" name="jumlah" value="<?php echo $row['jumlah']; ?>" min="0" required>
                        <small class="text-muted">Masukkan jumlah stok yang baru</small>
                    </div>
                    
                    <div class="alert alert-warning mb-0">
                        <i class="ti ti-alert-triangle"></i> Perubahan akan langsung mempengaruhi total stok obat
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-warning" name="edit"><i class="ti ti-device-floppy"></i> Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus Stok (hanya untuk petugas) -->
<div class="modal fade" id="deleteStokModal<?php echo $row['id_stok']; ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="ti ti-alert-triangle"></i> Konfirmasi Hapus</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="hapusstokapoteker.php" method="POST">
                <input type="hidden" name="id_stok" value="<?php echo $row['id_stok']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus stok ini?</p>
                    <div class="alert alert-info">
                        <strong>Obat:</strong> <?php echo $row['nama_obat']; ?><br>
                        <strong>Gudang:</strong> <?php echo $row['nama_gudang']; ?><br>
                        <strong>Jumlah:</strong> <?php echo $row['jumlah']; ?> <?php echo $row['satuan']; ?>
                    </div>
                    <div class="alert alert-danger mb-0">
                        <i class="ti ti-alert-triangle"></i> <strong>Perhatian!</strong>
                        <ul class="mb-0 mt-2">
                            <li>Stok <?php echo $row['jumlah']; ?> unit akan dihapus dari gudang ini</li>
                            <li>Total stok obat akan berkurang</li>
                            <li>Data tidak dapat dikembalikan</li>
                        </ul>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus"><i class="ti ti-trash"></i> Ya, Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<?php } ?>

<script>
function loadObatInfo(id_obat) {
    if (id_obat) {
        const select = document.getElementById('id_obat');
        const option = select.options[select.selectedIndex];
        
        document.getElementById('info-kode').textContent = option.dataset.kode;
        document.getElementById('info-satuan').textContent = option.dataset.satuan;
        document.getElementById('info-stok').textContent = option.dataset.stok;
        document.getElementById('info-min').textContent = option.dataset.min;
        document.getElementById('info-max').textContent = option.dataset.max;
        
        document.getElementById('obat-info').classList.remove('d-none');
    } else {
        document.getElementById('obat-info').classList.add('d-none');
    }
}
</script>

<?php include 'footer.php'; ?>